VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCTL.OCX"
Begin VB.Form frmDemo 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "BASSCD Player Demo & CD Ripper Project"
   ClientHeight    =   7020
   ClientLeft      =   45
   ClientTop       =   435
   ClientWidth     =   7425
   Icon            =   "frmDemo.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   7020
   ScaleWidth      =   7425
   StartUpPosition =   2  'CenterScreen
   Begin VB.CommandButton cmdButton 
      Caption         =   "&Drive Info >>"
      Height          =   345
      Index           =   9
      Left            =   5940
      TabIndex        =   74
      Top             =   6540
      Width           =   1365
   End
   Begin VB.Timer tmrPlaybackPosition 
      Interval        =   50
      Left            =   6390
      Top             =   5820
   End
   Begin VB.TextBox txtCDAlbum 
      Height          =   285
      Left            =   90
      Locked          =   -1  'True
      TabIndex        =   51
      Top             =   1290
      Width           =   3045
   End
   Begin VB.TextBox txtCDArtist 
      Height          =   285
      Left            =   90
      Locked          =   -1  'True
      TabIndex        =   50
      Top             =   690
      Width           =   3045
   End
   Begin MSComctlLib.Slider SliderVolume 
      Height          =   1395
      Left            =   5985
      TabIndex        =   43
      Top             =   630
      Width           =   645
      _ExtentX        =   1138
      _ExtentY        =   2461
      _Version        =   393216
      Orientation     =   1
      LargeChange     =   1
      SmallChange     =   10
      Min             =   -100
      Max             =   0
      SelStart        =   -50
      TickStyle       =   2
      TickFrequency   =   100
      Value           =   -50
      TextPosition    =   1
   End
   Begin VB.PictureBox picVUMeter 
      Appearance      =   0  'Flat
      AutoRedraw      =   -1  'True
      AutoSize        =   -1  'True
      BackColor       =   &H80000005&
      FillColor       =   &H00FF8080&
      ForeColor       =   &H00FF8080&
      Height          =   1395
      Index           =   1
      Left            =   7035
      ScaleHeight     =   1365
      ScaleWidth      =   255
      TabIndex        =   42
      Top             =   630
      Width           =   285
   End
   Begin VB.PictureBox picVUMeter 
      Appearance      =   0  'Flat
      AutoRedraw      =   -1  'True
      AutoSize        =   -1  'True
      BackColor       =   &H80000005&
      FillColor       =   &H00FF8080&
      ForeColor       =   &H00FF8080&
      Height          =   1395
      Index           =   0
      Left            =   6780
      ScaleHeight     =   1365
      ScaleWidth      =   255
      TabIndex        =   41
      Top             =   630
      Width           =   285
   End
   Begin VB.CommandButton cmdButton 
      Caption         =   "&Unlock"
      Height          =   345
      Index           =   4
      Left            =   5940
      TabIndex        =   24
      Top             =   4410
      Width           =   1365
   End
   Begin VB.CommandButton cmdButton 
      Caption         =   "&Stop"
      Height          =   345
      Index           =   2
      Left            =   5940
      TabIndex        =   19
      Top             =   2910
      Width           =   1365
   End
   Begin VB.CommandButton cmdButton 
      Caption         =   "&Fade Out"
      Height          =   345
      Index           =   8
      Left            =   5940
      TabIndex        =   39
      Top             =   3480
      Width           =   1365
   End
   Begin VB.Frame Frame1 
      Caption         =   "CD Extraction"
      Height          =   3285
      Left            =   120
      TabIndex        =   32
      Top             =   3660
      Width           =   5685
      Begin VB.CommandButton cmdButton 
         Caption         =   "&Extract"
         Height          =   375
         Index           =   7
         Left            =   4440
         TabIndex        =   35
         Top             =   210
         Width           =   1095
      End
      Begin VB.OptionButton optExtractMode 
         Caption         =   "W&MA File"
         Height          =   255
         Index           =   1
         Left            =   180
         TabIndex        =   33
         Top             =   570
         Value           =   -1  'True
         Width           =   1065
      End
      Begin VB.Frame frameWMASettings 
         Height          =   2625
         Left            =   90
         TabIndex        =   52
         Top             =   570
         Width           =   5475
         Begin VB.PictureBox picWMAExtractOptions 
            BorderStyle     =   0  'None
            Height          =   2355
            Left            =   60
            ScaleHeight     =   2355
            ScaleWidth      =   5355
            TabIndex        =   53
            Top             =   240
            Width           =   5355
            Begin VB.CheckBox chkWMAFileTags 
               Caption         =   "WMA File Tags"
               Height          =   195
               Left            =   150
               TabIndex        =   54
               Top             =   720
               Value           =   1  'Checked
               Width           =   1485
            End
            Begin VB.ComboBox cmbWMAEncodingBitrate 
               Height          =   315
               Left            =   90
               Style           =   2  'Dropdown List
               TabIndex        =   73
               Top             =   270
               Width           =   5175
            End
            Begin VB.Frame frameOutputTags 
               Height          =   1575
               Left            =   30
               TabIndex        =   55
               Top             =   720
               Width           =   5295
               Begin VB.TextBox txtWMATags 
                  Height          =   285
                  Index           =   7
                  Left            =   3660
                  TabIndex        =   63
                  Text            =   "Year"
                  Top             =   1185
                  Width           =   1485
               End
               Begin VB.TextBox txtWMATags 
                  Height          =   285
                  Index           =   6
                  Left            =   1020
                  TabIndex        =   62
                  Text            =   "Genre"
                  Top             =   1185
                  Width           =   1485
               End
               Begin VB.TextBox txtWMATags 
                  Height          =   285
                  Index           =   5
                  Left            =   3660
                  TabIndex        =   61
                  Text            =   "Copyright"
                  Top             =   900
                  Width           =   1485
               End
               Begin VB.TextBox txtWMATags 
                  Height          =   285
                  Index           =   4
                  Left            =   1020
                  TabIndex        =   60
                  Text            =   "Rating"
                  Top             =   900
                  Width           =   1485
               End
               Begin VB.TextBox txtWMATags 
                  Height          =   285
                  Index           =   3
                  Left            =   3660
                  TabIndex        =   59
                  Text            =   "Description"
                  Top             =   615
                  Width           =   1485
               End
               Begin VB.TextBox txtWMATags 
                  Height          =   285
                  Index           =   2
                  Left            =   1020
                  TabIndex        =   58
                  Text            =   "Album Title"
                  Top             =   615
                  Width           =   1485
               End
               Begin VB.TextBox txtWMATags 
                  Height          =   285
                  Index           =   1
                  Left            =   3660
                  TabIndex        =   57
                  Text            =   "Artist"
                  Top             =   330
                  Width           =   1485
               End
               Begin VB.TextBox txtWMATags 
                  Height          =   285
                  Index           =   0
                  Left            =   1020
                  TabIndex        =   56
                  Text            =   "Title"
                  Top             =   330
                  Width           =   1485
               End
               Begin VB.Label lblWMATag 
                  Alignment       =   1  'Right Justify
                  Caption         =   "Year"
                  Height          =   225
                  Index           =   7
                  Left            =   2700
                  TabIndex        =   71
                  Top             =   1215
                  Width           =   885
               End
               Begin VB.Label lblWMATag 
                  Alignment       =   1  'Right Justify
                  Caption         =   "Genre"
                  Height          =   225
                  Index           =   6
                  Left            =   60
                  TabIndex        =   70
                  Top             =   1215
                  Width           =   915
               End
               Begin VB.Label lblWMATag 
                  Alignment       =   1  'Right Justify
                  Caption         =   "Album Title"
                  Height          =   225
                  Index           =   5
                  Left            =   30
                  TabIndex        =   69
                  Top             =   645
                  Width           =   915
               End
               Begin VB.Label lblWMATag 
                  Alignment       =   1  'Right Justify
                  Caption         =   "Copyright"
                  Height          =   225
                  Index           =   4
                  Left            =   2700
                  TabIndex        =   68
                  Top             =   930
                  Width           =   885
               End
               Begin VB.Label lblWMATag 
                  Alignment       =   1  'Right Justify
                  Caption         =   "Rating"
                  Height          =   225
                  Index           =   3
                  Left            =   30
                  TabIndex        =   67
                  Top             =   930
                  Width           =   915
               End
               Begin VB.Label lblWMATag 
                  Alignment       =   1  'Right Justify
                  Caption         =   "Description"
                  Height          =   225
                  Index           =   2
                  Left            =   2700
                  TabIndex        =   66
                  Top             =   645
                  Width           =   885
               End
               Begin VB.Label lblWMATag 
                  Alignment       =   1  'Right Justify
                  Caption         =   "Artist"
                  Height          =   225
                  Index           =   1
                  Left            =   2670
                  TabIndex        =   65
                  Top             =   360
                  Width           =   885
               End
               Begin VB.Label lblWMATag 
                  Alignment       =   1  'Right Justify
                  Caption         =   "Title"
                  Height          =   225
                  Index           =   0
                  Left            =   30
                  TabIndex        =   64
                  Top             =   360
                  Width           =   915
               End
            End
            Begin VB.Label lblBitrates 
               Caption         =   "WMA Encoding Bitrate"
               Height          =   225
               Left            =   30
               TabIndex        =   72
               Top             =   30
               Width           =   1935
            End
         End
      End
      Begin VB.OptionButton optExtractMode 
         Caption         =   "&WAV File"
         Height          =   255
         Index           =   0
         Left            =   180
         TabIndex        =   34
         Top             =   270
         Width           =   1155
      End
   End
   Begin MSComctlLib.Slider SliderPosition 
      Height          =   315
      Left            =   3240
      TabIndex        =   29
      Top             =   690
      Width           =   2595
      _ExtentX        =   4577
      _ExtentY        =   556
      _Version        =   393216
      LargeChange     =   1000
      SmallChange     =   100
      Max             =   10000
      TickFrequency   =   500
   End
   Begin VB.CommandButton cmdButton 
      Caption         =   "&Close"
      Height          =   345
      Index           =   6
      Left            =   5940
      TabIndex        =   23
      Top             =   5280
      Width           =   1365
   End
   Begin VB.CommandButton cmdButton 
      Caption         =   "P&ause/Resume"
      Height          =   345
      Index           =   1
      Left            =   5940
      TabIndex        =   22
      Top             =   2580
      Width           =   1365
   End
   Begin VB.CommandButton cmdButton 
      Caption         =   "&Open"
      Height          =   345
      Index           =   5
      Left            =   5940
      TabIndex        =   21
      Top             =   4950
      Width           =   1365
   End
   Begin VB.CommandButton cmdButton 
      Caption         =   "&Lock"
      Height          =   345
      Index           =   3
      Left            =   5940
      TabIndex        =   20
      Top             =   4080
      Width           =   1365
   End
   Begin VB.CommandButton cmdButton 
      Caption         =   "&Play"
      Height          =   345
      Index           =   0
      Left            =   5940
      TabIndex        =   18
      Top             =   2250
      Width           =   1365
   End
   Begin VB.Frame frameDriveInfo 
      Caption         =   "Drive Info"
      Height          =   6795
      Left            =   7560
      TabIndex        =   3
      Top             =   90
      Width           =   3705
      Begin VB.PictureBox Picture1 
         BorderStyle     =   0  'None
         Enabled         =   0   'False
         Height          =   5865
         Left            =   120
         ScaleHeight     =   5865
         ScaleWidth      =   3495
         TabIndex        =   4
         Top             =   240
         Width           =   3495
         Begin VB.CheckBox chkRWFlags 
            Caption         =   "Drive is open"
            Height          =   255
            Index           =   14
            Left            =   210
            TabIndex        =   44
            Top             =   4710
            Width           =   3285
         End
         Begin VB.CheckBox chkRWFlags 
            Caption         =   "Drive is locked"
            Height          =   255
            Index           =   13
            Left            =   210
            TabIndex        =   40
            Top             =   5520
            Width           =   3285
         End
         Begin VB.CheckBox chkRWFlags 
            Caption         =   "Drive can be locked"
            Height          =   255
            Index           =   12
            Left            =   60
            TabIndex        =   17
            Top             =   5174
            Width           =   3555
         End
         Begin VB.CheckBox chkRWFlags 
            Caption         =   "Drive can be opened / closed"
            Height          =   255
            Index           =   11
            Left            =   60
            TabIndex        =   16
            Top             =   4378
            Width           =   3555
         End
         Begin VB.CheckBox chkRWFlags 
            Caption         =   "Drive supports ""stream is accurate"""
            Height          =   255
            Index           =   10
            Left            =   60
            TabIndex        =   15
            Top             =   3980
            Width           =   3555
         End
         Begin VB.CheckBox chkRWFlags 
            Caption         =   "Drive can read CD audio"
            Height          =   255
            Index           =   9
            Left            =   60
            TabIndex        =   14
            Top             =   3582
            Width           =   3555
         End
         Begin VB.CheckBox chkRWFlags 
            Caption         =   "Drive can read multi-session discs"
            Height          =   255
            Index           =   8
            Left            =   60
            TabIndex        =   13
            Top             =   3184
            Width           =   3555
         End
         Begin VB.CheckBox chkRWFlags 
            Caption         =   "Drive can read in ""mode 2 form 2"" format"
            Height          =   255
            Index           =   7
            Left            =   60
            TabIndex        =   12
            Top             =   2786
            Width           =   3555
         End
         Begin VB.CheckBox chkRWFlags 
            Caption         =   "Drive can read in ""mode 2 form 1"" format"
            Height          =   255
            Index           =   6
            Left            =   60
            TabIndex        =   11
            Top             =   2388
            Width           =   3555
         End
         Begin VB.CheckBox chkRWFlags 
            Caption         =   "Drive can read DVD-RAM media"
            Height          =   255
            Index           =   5
            Left            =   60
            TabIndex        =   10
            Top             =   1990
            Width           =   3555
         End
         Begin VB.CheckBox chkRWFlags 
            Caption         =   "Drive can read DVD-R media"
            Height          =   255
            Index           =   4
            Left            =   60
            TabIndex        =   9
            Top             =   1592
            Width           =   3555
         End
         Begin VB.CheckBox chkRWFlags 
            Caption         =   "Drive can read DVD-ROM media"
            Height          =   255
            Index           =   3
            Left            =   60
            TabIndex        =   8
            Top             =   1194
            Width           =   3555
         End
         Begin VB.CheckBox chkRWFlags 
            Caption         =   "Drive can read CD-R/RW media ""method 2"""
            Height          =   255
            Index           =   2
            Left            =   60
            TabIndex        =   7
            Top             =   796
            Width           =   3555
         End
         Begin VB.CheckBox chkRWFlags 
            Caption         =   "Drive can read CD-RW media"
            Height          =   255
            Index           =   1
            Left            =   60
            TabIndex        =   6
            Top             =   398
            Width           =   3555
         End
         Begin VB.CheckBox chkRWFlags 
            Caption         =   "Drive can read CD-R media"
            Height          =   255
            Index           =   0
            Left            =   60
            TabIndex        =   5
            Top             =   0
            Width           =   3555
         End
      End
      Begin VB.Label lblMaxReadSpeed 
         Alignment       =   1  'Right Justify
         Height          =   225
         Left            =   2700
         TabIndex        =   31
         Top             =   6180
         Width           =   915
      End
      Begin VB.Label lblCacheSize 
         Alignment       =   1  'Right Justify
         Height          =   225
         Left            =   2700
         TabIndex        =   30
         Top             =   6450
         Width           =   915
      End
      Begin VB.Label Label2 
         Caption         =   "Maximum read speed"
         Height          =   225
         Index           =   0
         Left            =   180
         TabIndex        =   26
         Top             =   6180
         Width           =   1755
      End
      Begin VB.Label Label2 
         Caption         =   "Drive's cache size"
         Height          =   225
         Index           =   1
         Left            =   180
         TabIndex        =   25
         Top             =   6450
         Width           =   1755
      End
   End
   Begin VB.ListBox lstTracks 
      Height          =   1620
      Left            =   90
      TabIndex        =   2
      Top             =   1950
      Width           =   5655
   End
   Begin VB.ComboBox cmbCDDrives 
      Height          =   315
      Left            =   1470
      Sorted          =   -1  'True
      Style           =   2  'Dropdown List
      TabIndex        =   1
      Top             =   60
      Width           =   5865
   End
   Begin MSComctlLib.Slider SliderBalance 
      Height          =   315
      Left            =   3240
      TabIndex        =   36
      Top             =   1410
      Width           =   2595
      _ExtentX        =   4577
      _ExtentY        =   556
      _Version        =   393216
      LargeChange     =   10
      Min             =   -100
      Max             =   100
      TickFrequency   =   10
   End
   Begin VB.Label Label8 
      Caption         =   "Album"
      Height          =   225
      Index           =   1
      Left            =   90
      TabIndex        =   49
      Top             =   1080
      Width           =   1095
   End
   Begin VB.Label Label8 
      Caption         =   "Artist"
      Height          =   225
      Index           =   0
      Left            =   90
      TabIndex        =   48
      Top             =   480
      Width           =   1095
   End
   Begin VB.Label lblVolume 
      Alignment       =   2  'Center
      Caption         =   "Volume"
      Height          =   195
      Left            =   5820
      TabIndex        =   47
      Top             =   450
      Width           =   975
   End
   Begin VB.Label lblBalance 
      Alignment       =   1  'Right Justify
      Caption         =   "0"
      Height          =   225
      Left            =   4620
      TabIndex        =   46
      Top             =   1200
      Width           =   1095
   End
   Begin VB.Label Label6 
      Caption         =   "Click Track to begin playback"
      Height          =   255
      Left            =   90
      TabIndex        =   45
      Top             =   1710
      Width           =   3465
   End
   Begin VB.Label Label5 
      Caption         =   "Balance"
      Height          =   225
      Left            =   3360
      TabIndex        =   38
      Top             =   1200
      Width           =   1065
   End
   Begin VB.Label Label4 
      Alignment       =   1  'Right Justify
      Height          =   225
      Left            =   3780
      TabIndex        =   37
      Top             =   2040
      Width           =   1095
   End
   Begin VB.Label lblTrackPosition 
      Alignment       =   1  'Right Justify
      Height          =   225
      Left            =   4620
      TabIndex        =   28
      Top             =   480
      Width           =   1095
   End
   Begin VB.Label Label3 
      Caption         =   "Track Position"
      Height          =   225
      Left            =   3360
      TabIndex        =   27
      Top             =   480
      Width           =   1065
   End
   Begin VB.Label Label1 
      Caption         =   "Select CD Drive : "
      Height          =   195
      Left            =   60
      TabIndex        =   0
      Top             =   120
      Width           =   1515
   End
End
Attribute VB_Name = "frmDemo"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Const strCurrentModule As String = "frmDemo"

Private lCDTrackHandle          As Long     '// The Handle of the CD Track returned from BASS_CD_StreamCreate()
Private lCDDriveCount           As Long     '// Keep track of the number of CD drives
Private lDriveID                As Long     '// The ID of the Selected Drive
Private bInScrollingPosition    As Boolean  '// Flag to keep track of if the user is scrolling the playback position
Private mvarWMATagNames()       As String   '// Array to hold the WMA Tag title names
Private channels                As Integer  '// Channels, Mono or stereo

Dim buf() As Byte                           '// Buffer to hold decoding data

'// Structures for WAV Encoding
Private Type WAVEHEADER_RIFF    '12 bytes
    RIFF            As Long       '"RIFF" = &H46464952
    riffBlockSize   As Long       'pos + 44 - 8
    riffBlockType   As Long       '"WAVE" = &H45564157
End Type

Private Type WAVEHEADER_data    '8 bytes
   dataBlockType    As Long       '"data" = &H61746164
   dataBlockSize    As Long       'pos
End Type

Private Type WAVEFORMAT         '24 bytes
    wfBlockType     As Long       '"fmt " = &H20746D66
    wfBlockSize     As Long
    '--- block size begins from here = 16 bytes
    wFormatTag      As Integer
    nChannels       As Integer
    nSamplesPerSec  As Long
    nAvgBytesPerSec As Long
    nBlockAlign     As Integer
    wBitsPerSample  As Integer
End Type

'// Variables for WAV Encoding
Private wr                      As WAVEHEADER_RIFF
Private wf                      As WAVEFORMAT
Private wd                      As WAVEHEADER_data

Dim ChanInfo As BASS_CHANNELINFO


Private Sub lstTracks_Click()
    Call PlayTrack(lstTracks.ListIndex)
End Sub


Private Sub optExtractMode_Click(Index As Integer)
    '// Depending o the value of the optionbox Enable/Disable the picturebox
    '// that hold the WMA tag fields and Encoding Bitrates.
    picWMAExtractOptions.Enabled = (optExtractMode(1).value = True)
End Sub


Private Sub SliderVolume_Change()
    lblVolume.Caption = "Volume : " & CLng(Abs(SliderVolume.value / 10))
End Sub

Private Sub SliderVolume_Scroll()
    '// set volume
    Call BASS_ChannelSetAttributes(lCDTrackHandle, -1, Abs(SliderVolume.value), -101)
    lblVolume.Caption = "Volume : " & CLng(Abs(SliderVolume.value / 10))
End Sub


Private Sub SliderBalance_Scroll()
    '// Set Balance
    Call BASS_ChannelSetAttributes(lCDTrackHandle, -1, -1, SliderBalance.value)
    lblBalance.Caption = SliderBalance.value
End Sub


Private Sub SliderPosition_Click()
    '// Set Playback Position
    Call BASS_ChannelSetPosition(lCDTrackHandle, (SliderPosition.value / 10000) * BASS_StreamGetLength(lCDTrackHandle))
End Sub


Private Sub SliderPosition_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)
    '// Set Flag to True
    bInScrollingPosition = True
End Sub


Private Sub SliderPosition_MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)
    '// Reset Flag
    bInScrollingPosition = False
End Sub


Private Sub tmrPlaybackPosition_Timer()
Dim lngTrackLength              As Long
Dim lngCurrentPosition          As Long
Dim sngCurrentPercentage        As Single
Dim lLevel                      As Long

    '// Check Open/Locked flags
    chkRWFlags(14).value = IIf(BASS_CD_DoorIsOpen(lDriveID), vbChecked, vbUnchecked)
    chkRWFlags(13).value = IIf(BASS_CD_DoorIsLocked(lDriveID), vbChecked, vbUnchecked)
    
    '// Check the OpenFlag and the number of tracks
    If chkRWFlags(14).value = vbUnchecked And (lstTracks.ListCount = 0) Then
        '// Load the tracks if the drive is closed and there is no tracks
        Call LoadTrackList
    ElseIf chkRWFlags(14).value = vbChecked And (lstTracks.ListCount > 0) Then
        '// Stop Playback
        Call BASS_ChannelStop(lCDTrackHandle)
        '// Clear Tracks
        lstTracks.Clear
    End If
    
    '// If there is no currently playing track then clear the values
    If BASS_ChannelIsActive(lCDTrackHandle) = BASSFALSE Then
        SliderPosition.value = 0
        lblTrackPosition.Caption = ""
        picVUMeter(0).Cls
        picVUMeter(1).Cls
        Exit Sub
    End If
    
    '// Get & visually display the left and right channel values
    lLevel = BASS_ChannelGetLevel(lCDTrackHandle)
    If (lLevel <> -1) Then
        picVUMeter(0).Cls
        picVUMeter(0).Line (0, ScaleHeight)-(picVUMeter(0).ScaleWidth, picVUMeter(0).ScaleHeight - ((LoWord(lLevel) / 100) * picVUMeter(0).ScaleHeight)), , BF ' Left Channel
        picVUMeter(1).Cls
        picVUMeter(1).Line (0, ScaleHeight)-(picVUMeter(1).ScaleWidth, picVUMeter(1).ScaleHeight - ((HiWord(lLevel) / 100) * picVUMeter(1).ScaleHeight)), , BF ' Left Channel
    Else
        picVUMeter(0).Cls
        picVUMeter(1).Cls
    End If
    
    '// Exit if user is scrolling position
    If bInScrollingPosition Then Exit Sub
    
    '// Get the overall track length
    lngTrackLength = BASS_StreamGetLength(lCDTrackHandle)
    '// Get the current position
    lngCurrentPosition = BASS_ChannelGetPosition(lCDTrackHandle)
    '// Calculate the percentage
    sngCurrentPercentage = lngCurrentPosition / lngTrackLength
    
    '// Set the position slider
    SliderPosition.value = sngCurrentPercentage * SliderPosition.max
    
    '// Display the current position
    lblTrackPosition.Caption = Seconds2HMS(BASS_ChannelBytes2Seconds(lCDTrackHandle, lngCurrentPosition)) & " / " & _
                       Seconds2HMS(BASS_ChannelBytes2Seconds(lCDTrackHandle, lngTrackLength))
    
    
End Sub


Private Sub cmbCDDrives_Click()

    '// Retreive the DriveID
    lDriveID = cmbCDDrives.ItemData(cmbCDDrives.ListIndex)
    
    '// Get the CD details
    Call LoadCDDrive
    
    '// Populate the listbox with the tracks
    Call LoadTrackList

End Sub


Private Sub cmdButton_Click(Index As Integer)
    
    '// What button was clicked?
    Select Case Index
        Case 0      '// PLAY
            Call PlayTrack(lstTracks.ListIndex)
            
        Case 1      '// PAUSE / RESUME
            If BASS_ChannelIsActive(lCDTrackHandle) = BASS_ACTIVE_PAUSED Then
                Call BASS_ChannelResume(lCDTrackHandle)
            Else
                Call BASS_ChannelPause(lCDTrackHandle)
            End If
            
        Case 2      '// STOP
            Call BASS_ChannelStop(lCDTrackHandle)
            
        Case 3      '// LOCK
            Call BASS_CD_Door(lDriveID, BASS_CD_DOOR_LOCK)
        
        Case 4      '// UNLOCK
            Call BASS_CD_Door(lDriveID, BASS_CD_DOOR_UNLOCK)
        
        Case 5      '// OPEN
            lstTracks.Clear
            Call BASS_ChannelStop(lCDTrackHandle)
            Call BASS_CD_Door(lDriveID, BASS_CD_DOOR_OPEN)
            
        Case 6      '// CLOSE
            Call BASS_CD_Door(lDriveID, BASS_CD_DOOR_CLOSE)
            Call LoadCDDrive
            
        Case 7      '// EXTRACT
            '// Stop Playback
            Call BASS_ChannelStop(lCDTrackHandle)
            
            '// Determine what format to rip to
            If optExtractMode(0).value = True Then
                Call ExtractAudioTrackToWav(lstTracks.ListIndex)
            Else
                Call ExtractAudioTrackToWMA(lstTracks.ListIndex, cmbWMAEncodingBitrate.ItemData(cmbWMAEncodingBitrate.ListIndex))
            End If
        
        Case 8      '// FADE OUT
            Call FadeOutTrack
        
        Case 9      '// Show Drive Info
            Me.Width = IIf(Me.Width = 11490, 7515, 11490)
            cmdButton(9).Caption = IIf(Me.Width = 11490, "&Drive Info <<", "&Drive Info >>")
            
    End Select
    
    
End Sub


Private Sub Form_Load()
Dim i               As Integer
Dim lCDDrive        As Long
Dim sDriveLetter    As String
Dim lDriveLetter    As Long

    'change and set the current path
    'so it won't ever tell you that bass.dll isn't found
    ChDrive App.Path
    ChDir App.Path

    'check if "bass.dll" is exists
    'If FileExists(RPP(App.Path) & "bass.dll") = False Then
    '    MsgBox "BASS.DLL does not exists", vbCritical, "BASS.DLL"
    '    End
    'End If

    'Check that BASS 2.0 was loaded
    If BASS_GetStringVersion <> "2.0" Then
        MsgBox "BASS version 2.0 was not loaded", vbCritical, "Bass.Dll"
        End
    End If

    'Start digital output
    '// If you prefer not to use this flag be sure to change the SliderVolume.Max property to -100
    If (BASS_Init(1, 44100, 0, Me.hwnd, 0) = 0) Then
        MsgBox "Error: Couldn't Initialize Digital Output", vbCritical, "Digital output"
        End
    End If
    
    '// Populate Combobox with Drives
    i = 0
    lCDDrive = BASS_CD_GetDriveDescription(i)
    While lCDDrive <> 0
        '// Get Drive Letter
        lDriveLetter = BASS_CD_GetDriveLetter(i)
        sDriveLetter = Chr$(65 + lDriveLetter)
        
        '// Add to combo
        cmbCDDrives.AddItem sDriveLetter & ": " & VBStrFromAnsiPtr(lCDDrive)
        cmbCDDrives.ItemData(cmbCDDrives.NewIndex) = i
        
        '// Get Next Drive
        i = i + 1
        lCDDrive = BASS_CD_GetDriveDescription(i)
        
    Wend
    
    '// Select first CD Drive in list
    If cmbCDDrives.ListCount > 0 Then cmbCDDrives.ListIndex = 0
    
    '// Save the number of CD Drives
    lCDDriveCount = i - 1
    
    '// Populate the WMA Encoding Rates
    Call LoadWMAEncoderRates
    
    '// Load an array of the Names of each of the WMA Tags
    mvarWMATagNames = Split("Title,Author,WM/AlbumTitle,Description,Rating,Copyright,WM/Genre,WM/Year", ",")

    '// Set slider to volume level
    SliderVolume.value = -BASS_GetVolume
    
    '// Disable the Slider's Tooltip
    Call DisableSliderTooltip(Me.SliderBalance.hwnd)
    Call DisableSliderTooltip(Me.SliderPosition.hwnd)
    Call DisableSliderTooltip(Me.SliderVolume.hwnd)
    
    '// Set initial Width
    Me.Width = 7515
    
    '// Set tabstops to align the time
    Call SetTrackListTabStops
    
End Sub


Private Sub LoadCDDrive()
Dim oCDINFO         As BASS_CD_INFO

    '// Create/Define the BASS_CD_INFO structure
    oCDINFO.size = Len(oCDINFO)
    
    '// Get CD Info
    Call BASS_CD_GetInfo(lDriveID, oCDINFO)
    
    '// Populate the fields
    chkRWFlags(0).value = IIf(CBool(oCDINFO.rwflags And BASS_CD_RWFLAG_READCDR), vbChecked, vbUnchecked)
    chkRWFlags(1).value = IIf(CBool(oCDINFO.rwflags And BASS_CD_RWFLAG_READCDRW), vbChecked, vbUnchecked)
    chkRWFlags(2).value = IIf(CBool(oCDINFO.rwflags And BASS_CD_RWFLAG_READCDRW2), vbChecked, vbUnchecked)
    chkRWFlags(3).value = IIf(CBool(oCDINFO.rwflags And BASS_CD_RWFLAG_READDVD), vbChecked, vbUnchecked)
    chkRWFlags(4).value = IIf(CBool(oCDINFO.rwflags And BASS_CD_RWFLAG_READDVDR), vbChecked, vbUnchecked)
    chkRWFlags(5).value = IIf(CBool(oCDINFO.rwflags And BASS_CD_RWFLAG_READDVDRAM), vbChecked, vbUnchecked)
    chkRWFlags(6).value = IIf(CBool(oCDINFO.rwflags And BASS_CD_RWFLAG_READM2F1), vbChecked, vbUnchecked)
    chkRWFlags(7).value = IIf(CBool(oCDINFO.rwflags And BASS_CD_RWFLAG_READM2F2), vbChecked, vbUnchecked)
    chkRWFlags(8).value = IIf(CBool(oCDINFO.rwflags And BASS_CD_RWFLAG_READMULTI), vbChecked, vbUnchecked)
    chkRWFlags(9).value = IIf(CBool(oCDINFO.rwflags And BASS_CD_RWFLAG_READCDDA), vbChecked, vbUnchecked)
    chkRWFlags(10).value = IIf(CBool(oCDINFO.rwflags And BASS_CD_RWFLAG_READCDDASIA), vbChecked, vbUnchecked)
    
    chkRWFlags(11).value = oCDINFO.canopen
    chkRWFlags(12).value = oCDINFO.canlock
    
    '// Set the status of the Open / Clsoe buttons if the drive doesn't support it
    If CBool(oCDINFO.canopen) Then
        cmdButton(5).Enabled = True
        cmdButton(6).Enabled = True
    Else
        cmdButton(5).Enabled = False
        cmdButton(6).Enabled = False
    End If
    
    '// Set the Lock / Unlock buttons based on the value of the .CanLock property
    If CBool(oCDINFO.canlock) Then
        chkRWFlags(13).value = BASS_CD_DoorIsLocked(lDriveID)
        cmdButton(3).Enabled = True
        cmdButton(4).Enabled = True
    Else
        chkRWFlags(13).value = vbGrayed
        cmdButton(3).Enabled = False
        cmdButton(4).Enabled = False
    End If
    
    lblMaxReadSpeed.Caption = Format$(oCDINFO.maxspeed, "###,### Kbps")
    lblCacheSize.Caption = Format$(oCDINFO.cache, "###,### Kbps")
    
End Sub


'check if any file exists
Function FileExists(ByVal FileName As String) As Boolean
    On Local Error Resume Next
    FileExists = (Dir$(FileName) <> "")
End Function


' RPP = Return Proper Path
Function RPP(ByVal fp As String) As String
    RPP = IIf(Mid(fp, Len(fp), 1) <> "\", fp & "\", fp)
End Function


'// Quick and Dirty routine to convert a value of seconds into a formatted hh:mm:ss string
Public Function Seconds2HMS(ByVal lngSeconds As Long) As String
Dim CurrentHSecs    As Double
Dim Hours           As Double
Dim Mins            As Double
Dim Secs            As Double
Dim HSecs           As Double

    CurrentHSecs = Int((lngSeconds) + 0.5)
    Hours = Int(CurrentHSecs \ 3600)
    CurrentHSecs = CurrentHSecs - (Hours * 3600)
    Mins = Int(CurrentHSecs \ 60)
    CurrentHSecs = CurrentHSecs - (Mins * 60)
    Secs = CInt(CurrentHSecs)
    
    If Hours > 0 Then
        Seconds2HMS = Right("00" & Hours, 2) & ":" & Right("00" & Mins, 2) & ":" & Right("00" & Secs, 2)
    Else
        Seconds2HMS = Right("00" & Mins, 2) & ":" & Right("00" & Secs, 2) ' & "." & Right("00" & HSecs, 2)
    End If

End Function


Private Sub Form_QueryUnload(Cancel As Integer, UnloadMode As Integer)
Dim i           As Long
   
    '// Make sure we unlock the drives :)
    For i = 0 To lCDDriveCount
        Call BASS_CD_Door(i, BASS_CD_DOOR_UNLOCK)
    Next i
    
    '// Close down BASS
    Call BASS_Stop
    Call BASS_Free
    
End Sub


Public Sub CDError()

    '// Stop the playback
    Call BASS_ChannelStop(lCDTrackHandle)
    '// Free the stream
    Call BASS_StreamFree(lCDTrackHandle)
    '// Display error
    MessageBox Me.hwnd, "There was an error playing back and Audio CD stream. Most probable cause is the CD drive was opened.", "Error", vbCritical
    '// Clear the track list
    lstTracks.Clear
    '// Reset Position
    SliderPosition.value = 0
    
End Sub


Public Sub PlayNextTrack(lCurrentTrackNumber As Long)

    '// INCR the track number and cycle when we get to the end of the list
    If lCurrentTrackNumber = lstTracks.ListCount - 1 Then
        lstTracks.ListIndex = 0
        Call PlayTrack(0)
    Else
        lstTracks.ListIndex = lCurrentTrackNumber + 1
        Call PlayTrack(lCurrentTrackNumber + 1)
    End If

End Sub


Private Sub PlayTrack(lTrack As Long)
    
    '// Stop current playback
    Call BASS_ChannelStop(lCDTrackHandle)
    
    '// Create new stream
    lCDTrackHandle = BASS_CD_StreamCreate(lDriveID, lTrack, BASS_STREAM_AUTOFREE Or BASS_CD_FREEOLD)
    
    '// set volume
    Call BASS_ChannelSetAttributes(lCDTrackHandle, -1, Abs(SliderVolume.value), -101)
    
    '// Play stream
    Call BASS_StreamPlay(lCDTrackHandle, BASSTRUE, 0&)
    
    '// Set END & ERROR syncs
    Call BASS_ChannelSetSync(lCDTrackHandle, BASS_SYNC_ONETIME Or BASS_SYNC_END, 0&, AddressOf CDTRACKEND_SYNCPROC, lTrack)
    Call BASS_ChannelSetSync(lCDTrackHandle, BASS_SYNC_ONETIME Or BASS_SYNC_CD_ERROR, 0&, AddressOf CDERROR_SYNCPROC, 0&)
    
    '// Set FADEOFF sync. Note for SLIDE Syncs : Use BASS_ChannelSetSync
    Call BASS_ChannelSetSync(lCDTrackHandle, BASS_SYNC_ONETIME Or BASS_SYNC_SLIDE, 0&, AddressOf CDTRACKEND_SYNCPROC, lTrack)
    
End Sub


Private Sub ExtractAudioTrackToWav(lTrack As Long)
On Error GoTo Err_Init

Dim pos             As Long
Dim flags           As Long
Dim ff              As Long
Dim lngTimer        As Long

    '// See how long it took
    lngTimer = Timer
    
    '// Lock Drive
    Call BASS_CD_Door(lDriveID, BASS_CD_DOOR_LOCK)

    '// Crate Stream for decoding
    lCDTrackHandle = BASS_CD_StreamCreate(lDriveID, lTrack, BASS_STREAM_DECODE Or BASS_STREAM_AUTOFREE)
    If lCDTrackHandle = 0 Then
        '// Something went wrong
        MsgBox "Unable to Create CD Stream!"
        GoTo ExitRoutine
    End If
    
    '// Keep user from pressing any buttons
    '// NOT the best way. Just Quick & Dirty.
    Me.Enabled = False
    
    'Set WAV Format
    Call BASS_ChannelGetInfo(lCDTrackHandle, ChanInfo)
    flags = ChanInfo.flags
    channels = ChanInfo.chans
     
    If channels > 2 Then channels = 2
    
    wf.wFormatTag = 1
    wf.nChannels = channels
    Call BASS_ChannelGetAttributes(lCDTrackHandle, wf.nSamplesPerSec, -1, -1)
    wf.wBitsPerSample = IIf(flags And BASS_SAMPLE_8BITS, 8, 16)
    wf.nBlockAlign = wf.nChannels * wf.wBitsPerSample / 8
    wf.nAvgBytesPerSec = wf.nSamplesPerSec * wf.nBlockAlign
    wf.wfBlockType = &H20746D66        '"fmt "
    wf.wfBlockSize = 16
        
    'Set WAV "RIFF" header
    wr.RIFF = &H46464952             '"RIFF"
    wr.riffBlockSize = 0      'after convertion
    wr.riffBlockType = &H45564157    '"WAVE"
    
    'set WAV "data" header
    wd.dataBlockType = &H61746164     '"data"
    wd.dataBlockSize = 0       'after convertion
    
    'create the output file
    ff = FreeFile
    Open RPP(App.Path) & "TRACK" & CStr(lTrack + 1) & ".WAV" For Binary Lock Read Write As #ff
    
    'Write WAV Header to file
    Put #ff, , wr    'RIFF
    Put #ff, , wf    'Format
    Put #ff, , wd    'data
    
    pos = 0
    ReDim buf(19999) As Byte
    
    '// Loop and read all the data
    While BASS_ChannelIsActive(lCDTrackHandle)
        ReDim Preserve buf(BASS_ChannelGetData(lCDTrackHandle, buf(0), 20000) - 1) As Byte
        'write data to WAV file
        Put #ff, , buf
        pos = BASS_ChannelGetPosition(lCDTrackHandle)
        
        'Call Sleep(1)   'don't hog the CPU too much :)
        DoEvents        'in case you want to exit...
    Wend
    
    Call BASS_ChannelStop(lCDTrackHandle)
    Call BASS_StreamFree(lCDTrackHandle)
    
    'complete WAV header
    wr.riffBlockSize = pos + 44 - 8
    wd.dataBlockSize = pos
    
    On Error Resume Next
        
    Put #ff, 5, wr.riffBlockSize
    Put #ff, 41, wd.dataBlockSize
    
    '//
    MsgBox "WMA File Encoded. Encoding took " & Format$(Timer - lngTimer, "###.#") & " seconds.", vbOKOnly, "WAV Encoding"
    
No_Err:

ExitRoutine:
    '// CleanUp
    Erase buf()
        
    '// UnLock Drive
    Call BASS_CD_Door(lDriveID, BASS_CD_DOOR_UNLOCK)
    
    '// Stop / Free the decoding stream
    If lCDTrackHandle Then Call BASS_ChannelStop(lCDTrackHandle)
    If lCDTrackHandle Then Call BASS_StreamFree(lCDTrackHandle)
    
    '// Close the output file
    Close #ff
    
    '// Enable the form
    Me.Enabled = True
    Exit Sub

Err_Init:
    HandleError strCurrentModule, "ExtractAudioTrack", Err.Number, Err.Description
    GoTo ExitRoutine:
    
End Sub


Private Sub ExtractAudioTrackToWMA(lTrack As Long, lngBitrate As Long)
On Error GoTo Err_Init

Dim flags               As Long
Dim pos                 As Long
Dim lngWMAEncodeHandle  As Long
Dim strOutputFilename   As String
Dim lngReturn           As Long
Dim i                   As Long

Dim lngTimer            As Long

    '// See how long it took
    lngTimer = Timer
    
    '// Lock Drive
    Call BASS_CD_Door(lDriveID, BASS_CD_DOOR_LOCK)
    
    '// Crate Stream for decoding
    lCDTrackHandle = BASS_CD_StreamCreate(lDriveID, lTrack, BASS_STREAM_DECODE Or BASS_STREAM_AUTOFREE)
    If lCDTrackHandle = 0 Then
        '// Something went wrong
        Call ThrowError("Unable to Create CD Stream!", BASS_ErrorGetCode)
        GoTo ExitRoutine
    End If
    
    '// Keep user from pressing any buttons
    '// NOT the best way. Just Quick & Dirty.
    Me.Enabled = False

    '// Create the output filename
    strOutputFilename = RPP(App.Path) & "TRACK" & CStr(lTrack + 1) & ".WMA"

    '// Open Output File
    '// We Know the Freq will be 44100.
    lngWMAEncodeHandle = BASS_WMA_EncodeOpenFile(44100, BASS_WMA_ENCODE_TAGS, lngBitrate, strOutputFilename)
    
    '// Exit if there was an error opening/creating the file
    If lngWMAEncodeHandle = 0 Then
        '// Error
        Call ThrowError("An error occured while opening output file.", BASS_ErrorGetCode)
        Exit Sub
    End If
    
    If chkWMAFileTags.value = vbChecked Then
        '// Populate Tags
        For i = 0 To 7
            If txtWMATags(i) <> "" Then
                Call BASS_WMA_EncodeSetTag(lngWMAEncodeHandle, mvarWMATagNames(i), txtWMATags(i).text)
            End If
        Next i
    End If
    
    '// Close Tags
    '// DO NOT REMOVE : Routine must be called even if there are NO Tags because we are using the BASS_WMA_ENCODE_TAGS flag
    Call BASS_WMA_EncodeSetTag(lngWMAEncodeHandle, "", "")
    
    '// Buffer to hold data
    ReDim buf(19999) As Byte

    '// Loop and read all the data
    Do While BASS_ChannelIsActive(lCDTrackHandle)
    
        '// Get Some Data
        ReDim Preserve buf(BASS_ChannelGetData(lCDTrackHandle, buf(0), 20000) - 1) As Byte
        
        '// Send Data to be Encoded
        lngReturn = BASS_WMA_EncodeWrite(lngWMAEncodeHandle, VarPtr(buf(0)), UBound(buf()) + 1)

        '// Error ??
        If lngReturn = 0 Then
            '// Error
            Call ThrowError("An error occured while encoding WMA data.", BASS_ErrorGetCode)
            Exit Do
        End If

        '// Don't want to hog ALL the CPU :)
        DoEvents
    Loop

    '// Close the Encoding Handle
    Call BASS_WMA_EncodeClose(lngWMAEncodeHandle)

    '//
    MsgBox "WMA File Encoded. Encoding took " & Format$(Timer - lngTimer, "###.#") & " seconds.", vbOKOnly, "WMA Encoding"
    

ExitRoutine:
    '// CleanUp
    Erase buf()
    
    '// UnLock Drive
    Call BASS_CD_Door(lDriveID, BASS_CD_DOOR_UNLOCK)
    
    '// Stop / Free the Decoding stream
    If lCDTrackHandle Then Call BASS_ChannelStop(lCDTrackHandle)
    If lCDTrackHandle Then Call BASS_StreamFree(lCDTrackHandle)
    
    '// Stop / Free the Encoding stream
    If lngWMAEncodeHandle Then Call BASS_ChannelStop(lngWMAEncodeHandle)
    If lngWMAEncodeHandle Then Call BASS_StreamFree(lngWMAEncodeHandle)
    
    '// Enable Form
    Me.Enabled = True
    Exit Sub

Err_Init:
    HandleError strCurrentModule, "ExtractAudioTrackToWMA", Err.Number, Err.Description
    GoTo ExitRoutine:

End Sub


Private Sub LoadWMAEncoderRates()
On Error GoTo Err_Init

Dim ratesPTR        As Long    'a pointer to a memory location where rates array is stored
Dim aryEncRates(0)  As Long
Dim strEncodeRate   As String

    '// Get the available bitrates, from a memory location and add to collection
    '// This is fairly strait forward. Since we know the input file is from a CD the
    '// Sample Rate will always be 44100.
    '// It will always be stereo so we don't use the BASS_SAMPLE_MONO flag.
    ratesPTR = BASS_WMA_EncodeGetRates(44100, 0&)

    '// Make sure we got a Pointer.
    If (ratesPTR = 0) Then
        Call ThrowError("Error: Can't find a codec", BASS_ErrorGetCode)
        Exit Sub
    Else
        '// Move Pointer into Buffer
        Call CopyMemory(aryEncRates(0), ByVal ratesPTR, LenB(ratesPTR))
        
        '// Make sure we have a valid bitrate.
        While aryEncRates(0) <> 0
            '// Add to List
            cmbWMAEncodingBitrate.AddItem Format(CLng(aryEncRates(0) / 1000), "###,##0 Kbps")
            cmbWMAEncodingBitrate.ItemData(cmbWMAEncodingBitrate.NewIndex) = CLng(aryEncRates(0))
            
            '// INCR to find next bitrate
            ratesPTR = ratesPTR + LenB(ratesPTR)
            
            '// Move Pointer into Buffer
            Call CopyMemory(aryEncRates(0), ByVal ratesPTR, LenB(ratesPTR))
        Wend
    
    End If
    
No_Err:
    '// Select the first item.
    If cmbWMAEncodingBitrate.ListCount > 0 Then cmbWMAEncodingBitrate.ListIndex = 0

ExitRoutine:
    Exit Sub

Err_Init:
    HandleError strCurrentModule, "LoadWMAEncoderRates", Err.Number, Err.Description
    GoTo ExitRoutine:
End Sub


Private Sub FadeOutTrack()
    '// Begin fading out for 5 seconds
    Call BASS_ChannelSlideAttributes(lCDTrackHandle, -1, 0, -101, 5000)       ' 5000 = 5 Seconds
End Sub


Private Sub LoadTrackList()
Dim i               As Long
Dim lTrackCount     As Long
Dim lTrackLength    As Long
    
Dim lngCDTextPtr    As Long

    '// Clear Track List
    lstTracks.Clear
    
    '// Load Track List
    If BASS_CD_IsReady(lDriveID) Then
        '// Get number of tracks
        lTrackCount = BASS_CD_GetTracks(lDriveID)
        
        '// Make sure there wasn't an error
        If lTrackCount = -1 Then
            '// Error
            MsgBox "Error retreiving number of tracks."
            
        Else
            '// Get the CD-Text data from the CD
            lngCDTextPtr = BASS_CD_GetID(lDriveID, BASS_CDID_TEXT)
            
            '// See if the CD has and CD-Text
            If lngCDTextPtr <> 0 Then
                '// Use the CD-Text data to display a better track list
                Call LoadTrackListFromCDText(lngCDTextPtr, lTrackCount)
                
            Else
                '// Set the Artist / Album names
                txtCDArtist.text = "Unknown Artist"
                txtCDAlbum.text = "Unknown Album"
                
                '// Populate list
                For i = 0 To lTrackCount - 1
                    '// Get the length of the track in blocks
                    lTrackLength = BASS_CD_GetTrackLength(lDriveID, i)
                    '// Make sure it's valid
                    If lTrackLength > 0 Then
                        '// Convert to seconds
                        lTrackLength = lTrackLength / 176400
                        '// Add to track list
                        lstTracks.AddItem Format$(i + 1, "0#") & vbTab & "Track " & CStr(i + 1) & vbTab & "[" & Seconds2HMS(lTrackLength) & "]"
                    Else
                        Call ThrowError("There was an error.", BASS_ErrorGetCode)
                    End If
                Next i
                
            End If
            
        End If
        
    Else
    
    End If
End Sub


Public Sub LoadTrackListFromCDText(ByVal lngTagPtr As Long, ByVal lTrackCount As Long)
On Error GoTo Err_Init

Dim strTag              As String
Dim i                   As Long
Dim aryTitle()          As String
Dim aryPerformers()     As String
Dim lIndx               As Long
Dim lTrackLength        As Long

    '/////////////////////////////////////////////////////////////////////////////////////
    '// We are really only interested in the TITLE & PERFORMER tags.
    '// But there are several others including SONGWRITERx, COMPOSERx, ARRANGERx, MESSAGEx,
    '// GENREx, ISRCx, DISCIDx and UPCx, where x is the track number.
    '// Note: When "x" is 0, it applies to the whole disk, eg. "TITLE0" is the disk title.
    '/////////////////////////////////////////////////////////////////////////////////////

    '// To hold the track titles / artists
    ReDim aryTitle(lTrackCount) As String
    ReDim aryPerformers(lTrackCount) As String
    
    '// Get First Tag
    strTag = VBStrFromAnsiPtr(lngTagPtr)
    
    '// The last TAG will be a null CHR(0)
    While (strTag <> Chr(0)) And (strTag <> "")
        
        '// Determine what to do with the text
        If UCase$(Left$(strTag, 5)) = "TITLE" Then
            lIndx = CLng(Mid$(strTag, 6, InStr(strTag, "=") - 6))
            aryTitle(lIndx) = Mid$(strTag, InStr(strTag, "=") + 1)
            
        ElseIf UCase$(Left$(strTag, 9)) = "PERFORMER" Then
            lIndx = CLng(Mid$(strTag, 10, InStr(strTag, "=") - 10))
            aryPerformers(lIndx) = Mid$(strTag, InStr(strTag, "=") + 1)
        
        End If
        
        '// Move Pointer
        lngTagPtr = lngTagPtr + Len(strTag) + 1
        
        '// Get Next Tag
        strTag = VBStrFromAnsiPtr(lngTagPtr)
    Wend
    
    '// Set the CD Artist / Album names. Index 0 applies to the entire CD.
    txtCDArtist.text = aryPerformers(0)
    txtCDAlbum.text = aryTitle(0)
    
    '// Now that we got all the usable tags. Lets display it in the Listbox
    For i = 0 To lTrackCount - 1
        '// Get the length of the track in blocks
        lTrackLength = BASS_CD_GetTrackLength(lDriveID, i)
        '// Make sure it's valid
        If lTrackLength > 0 Then
            '// Convert to seconds
            lTrackLength = lTrackLength / 176400
            '// Add to listbox formatted as [##] Performer / Title          [00:00]
            lstTracks.AddItem Format$(i + 1, "0#") & vbTab & aryPerformers(i + 1) & " / " & aryTitle(i + 1) & vbTab & "[" & Seconds2HMS(lTrackLength) & "]"
        End If
    Next
    
No_Err:

ExitRoutine:
    '// Clean Up
    Erase aryTitle()
    Erase aryPerformers()
    
    Exit Sub

Err_Init:
    HandleError strCurrentModule, "LoadTrackListFromCDText", Err.Number, Err.Description
    GoTo ExitRoutine:
End Sub
